<?php

namespace Modules\Xero\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class XeroPurchaseOrder extends Data
{
    public function __construct(
        public string|Optional $PurchaseOrderID,
        public XeroContact|Optional $Contact,
        public string|Optional $Date,
        public string|Optional $Status, // DRAFT|SUBMITTED|AUTHORISED|BILLED|DELETED
        public string|Optional $LineAmountTypes, // Exclusive|Inclusive|NoTax
        public array|Optional $LineItems,
        public string|Optional $CurrencyCode,
        public float|Optional $CurrencyRate,
        public string|Optional $PurchaseOrderNumber,
        public array|Optional $json_object,
        public string|Optional $StatusAttributeString,
        public array|Optional $ValidationErrors,
    ) {
    }

    const STATUS_DRAFT = 'DRAFT';

    const STATUS_SUBMITTED = 'SUBMITTED';

    const STATUS_AUTHORISED = 'AUTHORISED';

    const STATUS_BILLED = 'BILLED';

    const STATUS_DELETED = 'DELETED';

    const LINE_AMOUNT_TYPE_EXCLUSIVE = 'Exclusive';

    const LINE_AMOUNT_TYPE_INCLUSIVE = 'Inclusive';

    const LINE_AMOUNT_TYPE_NO_TAX = 'NoTax';
}
