<?php

namespace Modules\Xero\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class XeroManualJournalDto extends Data
{
    public function __construct(
        public string|null|Optional $ManualJournalID,
        public string|Optional $Narration,
        public string|Optional $Date,
        public string|Optional $DateUTC,
        public string|Optional $UpdatedDateUTC,
        public string|Optional $Status, // DRAFT|POSTED|DELETED|VOIDED
        public string|Optional $LineAmountTypes, // Exclusive|Inclusive|NoTax
        public string|Optional $Url, // Exclusive|Inclusive|NoTax
        public array|Optional $JournalLines,
        public array|Optional $json_object,
        public string|Optional $StatusAttributeString,
        public array|Optional $ValidationErrors,
    ) {
    }

    const STATUS_DRAFT = 'DRAFT';

    const STATUS_POSTED = 'POSTED';

    const STATUS_DELETED = 'DELETED';

    const STATUS_VOIDED = 'VOIDED';

    const LINE_AMOUNT_TYPE_EXCLUSIVE = 'Exclusive';

    const LINE_AMOUNT_TYPE_INCLUSIVE = 'Inclusive';

    const LINE_AMOUNT_TYPE_NO_TAX = 'NoTax';
}
