<?php

namespace Modules\Xero\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class XeroInvoice extends Data
{
    public function __construct(
        public string|Optional $InvoiceID,
        public string|Optional $Type, // ACCPAY|ACCREC
        public XeroContact|Optional $Contact,
        public string|Optional $Date,
        public string|Optional $DueDate,
        public string|Optional $Status, // DRAFT|SUBMITTED|AUTHORISED
        public string|Optional $Url,
        public string|Optional $LineAmountTypes, // Exclusive|Inclusive|NoTax
        public array|Optional $LineItems,
        public string|Optional $InvoiceNumber,
        public string|Optional $CurrencyCode,
        public float|Optional $CurrencyRate,
        public array|Optional $json_object,
        public string|Optional $StatusAttributeString,
        public array|Optional $ValidationErrors,
    ) {
    }

    public function getId(): string|Optional
    {
        return $this->InvoiceID;
    }

    const TYPE_ACCREC = 'ACCREC';

    const TYPE_ACCPAY = 'ACCPAY';

    const STATUS_DRAFT = 'DRAFT';

    const STATUS_SUBMITTED = 'SUBMITTED';

    const STATUS_AUTHORISED = 'AUTHORISED';

    const STATUS_VOIDED = 'VOIDED';

    const STATUS_PAID = 'PAID';

    const LINE_AMOUNT_TYPE_EXCLUSIVE = 'Exclusive';

    const LINE_AMOUNT_TYPE_INCLUSIVE = 'Inclusive';

    const LINE_AMOUNT_TYPE_NO_TAX = 'NoTax';
}
