<?php

namespace Modules\Xero\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class XeroCreditNote extends Data
{
    const TYPE_ACCPAYCREDIT = 'ACCPAYCREDIT';

    const TYPE_ACCRECCREDIT = 'ACCRECCREDIT';

    const STATUS_DRAFT = 'DRAFT';

    const STATUS_SUBMITTED = 'SUBMITTED';

    const STATUS_AUTHORISED = 'AUTHORISED';

    const STATUS_VOIDED = 'VOIDED';

    const LINE_AMOUNT_TYPE_EXCLUSIVE = 'Exclusive';

    const LINE_AMOUNT_TYPE_INCLUSIVE = 'Inclusive';

    const LINE_AMOUNT_TYPE_NO_TAX = 'NoTax';

    public function __construct(
        public string|Optional $CreditNoteID,
        public string|Optional $Type, // ACCPAYCREDIT|ACCRECCREDIT
        public XeroContact|Optional $Contact,
        public string|Optional $Date,
        public string|Optional $Status, // DRAFT|SUBMITTED|AUTHORISED
        public string|Optional $LineAmountTypes, // Exclusive|Inclusive|NoTax
        public array|Optional $LineItems,
        public string|Optional $CurrencyCode,
        public float|Optional $CurrencyRate,
        public string|Optional $CreditNoteNumber,
        public string|Optional $Reference,
        public XeroInvoice|Optional $Invoice,
        public array|Optional $json_object,
        public string|Optional $StatusAttributeString,
        public array|Optional $ValidationErrors,
    ) {
    }

    public function getId(): string|Optional
    {
        return $this->CreditNoteID;
    }
}
