<?php

namespace Modules\Xero\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class XeroAddress extends Data
{
    public function __construct(
        public ?string $AddressType,
        public ?string $AddressLine1,
        public ?string $AddressLine2,
        public ?string $AddressLine3,
        public ?string $City,
        public ?string $PostalCode,
        public ?string $Country,
        public string|Optional $AttentionTo,
    ) {
    }

    const ADDRESS_TYPE_BILLING = 'POBOX';

    const ADDRESS_TYPE_DELIVERY = 'STREET';
}
