<?php

namespace Modules\Xero\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class XeroAccount extends Data
{
    public function __construct(
        public ?string $AccountID,
        public ?array $json_object,
        public string|Optional $StatusAttributeString,
        public array|Optional $ValidationErrors
    ) {
    }

    const CLASS_ASSET = 'ASSET';

    const CLASS_EQUITY = 'EQUITY';

    const CLASS_EXPENSE = 'EXPENSE';

    const CLASS_LIABILITY = 'LIABILITY';

    const CLASS_REVENUE = 'REVENUE';

    const TYPE_BANK = 'BANK';

    const TYPE_CURRENT_ASSET = 'CURRENT';

    const TYPE_CURRENT_LIABILITY = 'CURRLIAB';

    const TYPE_DEPRECIATION = 'DEPRECIATN';

    const TYPE_DIRECT_COSTS = 'DIRECTCOSTS';

    const TYPE_EQUITY = 'EQUITY';

    const TYPE_EXPENSE = 'EXPENSE';

    const TYPE_FIXED_ASSET = 'FIXED';

    const TYPE_INVENTORY = 'INVENTORY';

    const TYPE_LIABILITY = 'LIABILITY';

    const TYPE_NON_CURRENT_ASSET = 'NONCURRENT';

    const TYPE_OTHER_INCOME = 'OTHERINCOME';

    const TYPE_OVERHEAD = 'OVERHEADS';

    const TYPE_PREPAYMENT = 'PREPAYMENT';

    const TYPE_REVENUE = 'REVENUE';

    const TYPE_SALES = 'SALES';

    const TYPE_NON_CURRENT_LIABILITY = 'TERMLIAB';

    const TYPE_PAYG_LIABILITY = 'PAYGLIABILITY';

    const TYPE_SUPERANNUATION_EXPENSE = 'SUPERANNUATIONEXPENSE';

    const TYPE_SUPERANNUATION_LIABILITY = 'SUPERANNUATIONLIABILITY';

    const TYPE_WAGES_EXPENSE = 'WAGESEXPENSE';

    const STATUS_ACTIVE = 'ACTIVE';

    const STATUS_ARCHIVED = 'ARCHIVED';
}
