<?php

namespace Modules\Xero\Console;

use Illuminate\Console\Command;
use Modules\Xero\Jobs\XeroGetTransactionsJob;

class XeroGetTransactionsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:xero:transactions:get {ids}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Xero Transactions';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $ids = explode(',', $this->argument('ids'));

        dispatch(new XeroGetTransactionsJob($ids));
    }
}
