<?php

namespace Modules\WooCommerce\Managers;

use App\Abstractions\Integrations\IntegrationClientInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProductManager;
use App\Abstractions\Integrations\SalesChannels\SalesChannelProductRepositoryInterface;
use Exception;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceProduct;
use Modules\WooCommerce\Repositories\WooCommerceProductRepository;
use Modules\WooCommerce\Services\WooCommerceClient;

class WooCommerceProductManager extends AbstractSalesChannelProductManager
{
    private WooCommerceProductRepository $wooCommerceProductRepository;

    public function __construct(protected readonly WooCommerceIntegrationInstance|IntegrationInstanceInterface $wooCommerceIntegrationInstance)
    {
        $this->wooCommerceProductRepository = new WooCommerceProductRepository();
        $this->setModel(new WooCommerceProduct());

        parent::__construct($wooCommerceIntegrationInstance, new WooCommerceClient($this->wooCommerceIntegrationInstance), $this->wooCommerceProductRepository);

        config()->set('woo_commerce_mappings', $this->mappings);
    }

    public function getProductRepository(): SalesChannelProductRepositoryInterface
    {
        return $this->wooCommerceProductRepository;
    }

    public function postCreateSkuProducts()
    {
    }

    protected function syncInventory(?array $ids = []): void
    {
        // TODO: Implement syncInventory() method.
    }

    public function cacheProductListingQuantity(?array $productIds = []): void
    {
        // TODO: Implement cacheProductListingQuantity() method.
    }


}
