<?php

namespace Modules\WooCommerce\Jobs;

use Exception;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Managers\WooCommerceProductManager;
use Throwable;

/*
 * TODO: Should this be a unique job?
 */
class CreateSkuProductsFromWooCommerceJob extends WooCommerceBaseJob // implements ShouldBeUnique
{
    //public int $uniqueFor = 600;

    /**
     * @return string
     */
    /*public function uniqueId(): string
    {
        return 'create-sku-products-'.$this->amazonIntegrationInstance->id;
    }*/
    /**
     * Create a new job instance.
     *
     * @return void
     *
     * @throws Exception
     */
    public function __construct(protected WooCommerceIntegrationInstance $wooCommerceIntegrationInstance)
    {
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        (new WooCommerceProductManager($this->wooCommerceIntegrationInstance))->createSkuProducts([], true);
    }
}
