<?php

namespace Modules\WooCommerce\Http\Controllers;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProductController;
use App\Data\CreateSkuProductsFromSalesChannelData;
use App\Data\SalesChannelProductImportMappingData;
use App\Data\SalesChannelProductToSkuProductMappingCollectionData;
use App\Exceptions\ExportingEmptyDataException;
use App\Response;
use Exception;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceProduct;
use Modules\WooCommerce\Http\Resources\WooCommerceProductResource;
use Modules\WooCommerce\Jobs\RefreshWooCommerceProductsJob;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Throwable;

class WooCommerceProductController extends AbstractSalesChannelProductController
{
    protected function getModel(): string
    {
        return WooCommerceProduct::class;
    }

    protected function getResource(): string
    {
        return WooCommerceProductResource::class;
    }

    // Typehint $integrationInstance with the integration implementation
    public function indexForIntegration(Request $request, WooCommerceIntegrationInstance $integrationInstance)
    {
        return $this->abstractIndexForIntegration($request, $integrationInstance);
    }

    // Typehint $product with the integration implementation
    public function show(WooCommerceIntegrationInstance $integrationInstance, WooCommerceProduct $product): ?Response
    {
        return $this->abstractShow($product);
    }

    /**
     * @throws Throwable
     */
    public function createSkuProducts(CreateSkuProductsFromSalesChannelData $data, WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractCreateSkuProducts($data, $integrationInstance);
    }

    public function refresh(WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefresh(new RefreshWooCommerceProductsJob($integrationInstance, app($this->getModel())->refreshAdt()));
    }

    /**
     * @throws Throwable
     */
    public function mapProducts(SalesChannelProductToSkuProductMappingCollectionData $data, WooCommerceIntegrationInstance $integrationInstance)
    {
        return $this->abstractMapProducts($data, $integrationInstance);
    }

    /**
     * @throws ExportingEmptyDataException
     */
    protected function exportForIntegration(Request $request, WooCommerceIntegrationInstance $integrationInstance): BinaryFileResponse|Response|RedirectResponse
    {
        return $this->abstractExportForIntegration($request, $integrationInstance);
    }

    /**
     * @throws Exception
     */
    public function importMappings(SalesChannelProductImportMappingData $data, WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractImportMappings($data, $integrationInstance);
    }
}
