<?php

namespace Modules\WooCommerce\Http\Controllers;

use App\Abstractions\AbstractSimpleAuthenticationCallbackController;
use App\Abstractions\Integrations\AbstractIntegrationInstanceRepository;
use App\Abstractions\Integrations\Data\SimpleAuthenticationAuthorizationResponseInterface;
use App\Abstractions\Integrations\IntegrationClientInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Response;
use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Http\Request;
use Modules\WooCommerce\ApiDataTransferObjects\WooCommerceGetOrdersAdt;
use Modules\WooCommerce\ApiDataTransferObjects\WooCommerceGetProductsAdt;
use Modules\WooCommerce\Data\WooCommerceAuthorizationResponseData;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Jobs\RefreshWooCommerceOrdersJob;
use Modules\WooCommerce\Jobs\RefreshWooCommerceProductsJob;
use Modules\WooCommerce\Repositories\WooCommerceIntegrationInstanceRepository;
use Modules\WooCommerce\Services\WooCommerceClient;

class WooCommerceAuthenticationController extends AbstractSimpleAuthenticationCallbackController
{
    public function getIntegrationInstanceRepository(): AbstractIntegrationInstanceRepository
    {
        return app(WooCommerceIntegrationInstanceRepository::class);
    }

    /**
     * @throws Exception
     */
    public function getClient(IntegrationInstanceInterface $integrationInstance): IntegrationClientInterface
    {
        return new WooCommerceClient($integrationInstance);
    }

    public function getStateParameterName(): string
    {
        return 'user_id';
    }

    /**
     * @throws Exception
     */
    public function getRedirectUrl(WooCommerceIntegrationInstance $integrationInstance): Response
    {
        return $this->response->addData((new WooCommerceClient($integrationInstance))->getRedirectUrl());
    }

    /**
     * @throws Exception
     */
    public function callback(WooCommerceAuthorizationResponseData $data): void
    {
        /** @var WooCommerceIntegrationInstance $integrationInstance */
        $integrationInstance = parent::abstractCallback($data);
        dispatch(new RefreshWooCommerceProductsJob($integrationInstance, new WooCommerceGetProductsAdt()))->onQueue('sales-channels');
        dispatch(new RefreshWooCommerceOrdersJob($integrationInstance, new WooCommerceGetOrdersAdt()))->onQueue('sales-channels');
    }
}
