<?php

namespace Modules\WooCommerce\Entities;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelIntegrationInstance;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProductManager;
use App\Models\DataImportMapping;
use App\Models\Integration;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\DB;
use Modules\WooCommerce\Database\Factories\WooCommerceIntegrationInstanceFactory;
use Modules\WooCommerce\Managers\WooCommerceProductManager;
use Throwable;

/**
 * @property-read DataImportMapping $dataImportMapping
 */
class WooCommerceIntegrationInstance extends AbstractSalesChannelIntegrationInstance
{
    protected static function booted(): void
    {
        static::addGlobalScope('woo-commerce', function (Builder $query) {
            return $query->whereHas('integration', function (Builder $query) {
                $query->where('name', Integration::NAME_WOOCOMMERCE);
            });
        });
    }

    public static function getOrderClass(): string
    {
        return WooCommerceOrder::class;
    }

    public static function getOrderLineClass(): string
    {
        return WooCommerceOrderItem::class;
    }

    public static function getProductClass(): string
    {
        return WooCommerceProduct::class;
    }

    public static function newFactory(): Factory
    {
        return new WooCommerceIntegrationInstanceFactory();
    }

    public static function supportsUpdates(): bool
    {
        return true;
    }

    /**
     * @throws Exception
     */
    public function getProductManager(): AbstractSalesChannelProductManager
    {
        return new WooCommerceProductManager($this);
    }

    /*
    |--------------------------------------------------------------------------
    | Other
    |--------------------------------------------------------------------------
    */

    /**
     * @throws Throwable
     */
    public function delete()
    {
        DB::transaction(function () {
            /*
             * Clear all related records
             *
             * Many other models get deleted but handled through corresponding models
             */
            $this->apiLogs()->delete();
            $this->dataImportMapping()->delete();
            $this->orders->each->delete();
            $this->products->each->delete();
            $this->salesChannel()->delete();

            parent::delete();
        });
    }
}
