<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('woo_commerce_orders', function (Blueprint $table) {
            $table->dropColumn('date_completed');
            $table->dropColumn('date_modified_gmt');
            $table->dropColumn('date_created_gmt');
        });

        Schema::table('woo_commerce_orders', function (Blueprint $table) {
            $table->dateTime('date_completed_gmt')->storedAs("
            IF(json_unquote(json_extract(`json_object`, '$.date_completed_gmt')) = 'null', NULL, 
                str_to_date(
                    REPLACE(json_unquote(json_extract(`json_object`, '$.date_completed_gmt')), 'T', ' '),
                '%Y-%m-%d %H:%i:%s'
		        )
            )
            ")->nullable()->after('currency');
            $table->dateTime('date_modified_gmt')->storedAs("str_to_date(REPLACE(json_unquote(json_extract(`json_object`,'$.date_modified_gmt')), 'T', ' '), '%Y-%m-%d %H:%i:%s')")->nullable()->after('date_completed_gmt');
            $table->dateTime('date_created_gmt')->storedAs("str_to_date(REPLACE(json_unquote(json_extract(`json_object`,'$.date_created_gmt')), 'T', ' '), '%Y-%m-%d %H:%i:%s')")->nullable()->after('date_modified_gmt');
        });
    }
};
