<?php

use App\Models\Integration;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Integration::with([])
            ->firstOrCreate(['name' => Integration::NAME_WOOCOMMERCE],
                [
                    'description' => 'Integrate with WooCommerce as a Sales Channel',
                    'integration_settings_template' => [],
                    'image_url' => '/images/sales_channels/woocommerce_square.png',
                    'supports_multiple_instances' => true,
                    'integration_type' => Integration::TYPE_SALES_CHANNEL,
                ]
            );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Integration::query()->where('name', Integration::NAME_WOOCOMMERCE)->delete();
    }
};
