<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('woo_commerce_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('woo_commerce_order_id')->index()->constrained();

            $table->string('line_item_id')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.id'))");
            $table->string('name')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.name'))");
            $table->string('product_id')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.product_id'))");
            $table->string('quantity')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.quantity'))");
            $table->string('sku')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.sku'))");

            $table->json('json_object');

            // There might be multiple WooCommerce installations with overlapping IDs, that is why the composite constraint is being used here
            $table->unique(['line_item_id', 'woo_commerce_order_id'], 'woo_commerce_orders_items_line_item_id_composite_unique'); // Name must be less than 64 chars

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('woo_commerce_order_items');
    }
};
