<?php

namespace Modules\WooCommerce\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceProduct;

class WooCommerceProductFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = WooCommerceProduct::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var WooCommerceIntegrationInstance $wooCommerceIntegrationInstance */
        $wooCommerceIntegrationInstance = WooCommerceIntegrationInstance::query()->first();
        $productData = [
            'name' => $this->faker->name(),
            'slug' => $this->faker->slug(),
            'date_created_gmt' => $this->faker->date('Y-m-d H:i:s', 'now'),
            'date_modified_gmt' => $this->faker->date('Y-m-d H:i:s', 'now'),
            'type' => $this->faker->randomElement(['simple', 'variable']),
            'id' => $this->faker->randomNumber(),
            'status' => $this->faker->randomElement(['draft', 'pending', 'private', 'publish']),
            'featured' => $this->faker->numberBetween(0, 1),
            'catalog_visibility' => $this->faker->randomElement(['visible', 'catalog', 'search', 'hidden']),
            'sku' => $this->faker->ean13(),
            'price' => $this->faker->randomFloat(4, 0, 1000),
            'weight' => $this->faker->randomFloat(4, 0, 1000),
            'dimensions' => [
                'length' => $this->faker->randomFloat(4, 0, 1000),
                'width' => $this->faker->randomFloat(4, 0, 1000),
                'height' => $this->faker->randomFloat(4, 0, 1000),
            ],
        ];

        return [
            'integration_instance_id' => $wooCommerceIntegrationInstance->id,
            'json_object' => $productData,
        ];
    }
}
