<?php

namespace Modules\WooCommerce\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\WooCommerce\Entities\WooCommerceOrder;

class WooCommerceOrderItemFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\WooCommerce\Entities\WooCommerceOrderItem::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'woo_commerce_order_id' => WooCommerceOrder::factory(),
            'json_object' => [
                'id' => $this->faker->randomNumber(),
                'name' => $this->faker->name(),
                'product_id' => $this->faker->randomNumber(),
                'quantity' => $this->faker->randomNumber(1, 10),
                'sku' => $this->faker->word(),
            ],
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
