<?php

namespace Modules\WooCommerce\Database\Factories;

use App\Models\Integration;
use Database\Factories\IntegrationInstanceFactory;

class WooCommerceIntegrationInstanceFactory extends IntegrationInstanceFactory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\WooCommerce\Entities\WooCommerceIntegrationInstance::class;

    public function definition(): array
    {
        /** @var Integration $integration */
        $integration = Integration::query()->where('name', Integration::NAME_WOOCOMMERCE)->first();

        return [
            'integration_id' => $integration->id,
            'name' => $this->faker->sentence(3),
            'connection_settings' => [
                'consumer_key' => $this->faker->word(),
                'consumer_secret' => $this->faker->word(),
            ],
            'integration_settings' => [
                'url' => rtrim($this->faker->url(), '/'),
                'start_date' => now()->subYears(2)->toDateTimeString(),
            ],
        ];
    }
}
