<?php

namespace Modules\WooCommerce\Console;

use Exception;
use Illuminate\Console\Command;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Jobs\CreateSkuProductsFromWooCommerceJob;
use Modules\WooCommerce\Repositories\WooCommerceIntegrationInstanceRepository;

class CreateSkuProductsFromWooCommerceCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'woo-commerce:products:create-sku-products';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create SKU products from WooCommerce';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(private readonly WooCommerceIntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws Exception
     */
    public function handle(): void
    {
        $this->integrationInstanceRepository
            ->all()
            ->each(function (WooCommerceIntegrationInstance $wooCommerceIntegrationInstance) {
                /*
                 * TODO: Add condition to either integration query or each instance to eligible instances based on:
                 *  - auto create products = true
                 */
                if ($wooCommerceIntegrationInstance->integration_settings['auto_create_products']) {
                    dispatch(new CreateSkuProductsFromWooCommerceJob($wooCommerceIntegrationInstance));
                }
            });
    }
}
