<?php

namespace Modules\WooCommerce\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Modules\WooCommerce\Entities\WooCommerceOrder;

class WooCommerceUpdateOrderAdt implements ApiDataTransformerInterface
{
    public function __construct(
        public WooCommerceOrder $wooCommerceOrder,
        public string $status,
    ) {
    }

    public function transform(): array
    {
        $params = [
            'status' => $this->status,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
