<?php

namespace Modules\WooCommerce\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Modules\WooCommerce\ApiDataTransferObjects\Concerns\WooCommerceDatesTrait;

class WooCommerceGetOrdersAdt implements ApiDataTransformerInterface
{
    use WooCommerceDatesTrait;

    const DATES_TO_SANITIZE = [
        'modified_after',
        'after',
    ];

    public function __construct(
        public Carbon|string|null $modified_after = null,
        public Carbon|string|null $after = null,
        public ?int $days = null,
        public ?string $nextPage = null,
    ) {
        $this->sanitizeDates();

        if (! is_null($days)) {
            // TODO: This is not compatible with the WooCommerceRequestApo
            $this->setStartAndEndDateFromDays($days);
        }
    }

    public function transform(): array
    {
        $params = [
            'dates_are_gmt' => true,
            'order' => 'asc',
            'modified_after' => $this->modified_after?->toIso8601ZuluString(),
            'after' => $this->after?->toIso8601ZuluString(),
            'page' => $this->nextPage,
            'per_page' => 100,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
