<?php

namespace Modules\WooCommerce\ApiDataTransferObjects\Concerns;

use App\Helpers;
use Carbon\Carbon;

trait WooCommerceDatesTrait
{
    public function setStartAndEndDateFromDays(int $days): void
    {
        $this->start = Carbon::now('UTC')->subDays($days + 1);
        $this->end = Carbon::now('UTC')->subDay();
    }

    public function sanitizeDates(): void
    {
        foreach (self::DATES_TO_SANITIZE as $dateType) {
            if (is_string($this->{$dateType})) {
                $this->setDateFromLocalString($dateType, $this->{$dateType});
            }
        }
    }

    public function setDateFromLocalString(string $dateField, string $date): void
    {
        $this->{$dateField} = Helpers::dateLocalToUtc($date);
    }

    public function getZuluDate(string $dateField): ?string
    {
        return $this->{$dateField} ? $this->{$dateField}->toIso8601ZuluString() : null;
    }
}
