<?php

namespace Modules\Veracore\Transformers;

use App\Http\Resources\IntegrationInstanceResource;
use Modules\Veracore\Entities\VeracoreIntegrationInstance;

/**
 * @mixin VeracoreIntegrationInstance
 */
class VeracoreIntegrationInstanceResource extends IntegrationInstanceResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
        $results = parent::toArray($request);
        $results['linked_warehouse'] = $this->linkedWarehouse->only(['id', 'name', 'type']);
        return $results;
    }
}
