<?php

namespace Modules\Veracore\Services;

use Modules\Veracore\Entities\VeracoreIntegrationInstance;
use RuntimeException;
use Throwable;

class CredentialManager
{
    public function __construct(private readonly VeracoreIntegrationInstance $instance)
    {
    }

    public function getUsername(): string
    {
        return $this->instance->getUsername();
    }

    public function getPassword(): string
    {
        return $this->instance->getPassword();
    }

    public function getSystemId(): ?string
    {
        return $this->instance->connection_settings['systemId'] ?? '';
    }

    /**
     * @throws RuntimeException|Throwable
     */
    public function getAccessToken(): string
    {
        throw_if(
            empty($this->instance->connection_settings['access_token']),
            new RuntimeException('No Veracore Access Token Found.')
        );

        return $this->instance->connection_settings['access_token'];
    }

    public function updateAccessToken(array $payload): string
    {
        $this->instance->connection_settings = array_merge(
            $this->instance->connection_settings,
            [
                'access_token' => $payload['Token'],
                'access_token_expires_at' => $payload['UtcExpirationDate'],
                'last_api_error' => $payload['Error'] ?? null,
            ]
        );
        $this->instance->save();

        return $this->getAccessToken();
    }

    public function getIntegrationInstance(): VeracoreIntegrationInstance
    {
        return $this->instance;
    }
}
