<?php

namespace Modules\Veracore\Http\Controllers;

use App\Http\Controllers\ShippingProviderIntegrationInstanceController;
use App\Models\IntegrationInstance;
use App\Response;
use Modules\Veracore\Data\CreateVeracoreIntegrationInstanceData;
use Modules\Veracore\Data\UpdateVeracoreIntegrationInstanceData;
use Modules\Veracore\Data\VeracoreIntegrationInstanceData;

class VeracoreIntegrationInstanceController extends ShippingProviderIntegrationInstanceController
{

    /**
     * @param  IntegrationInstance  $integrationInstance
     * @return Response
     */
    public function show(IntegrationInstance $integrationInstance): Response
    {
        return $this->response->addData(
            VeracoreIntegrationInstanceData::from($integrationInstance)
        );
    }

    /**
     * @param  CreateVeracoreIntegrationInstanceData  $data
     * @return Response
     */
    public function store(CreateVeracoreIntegrationInstanceData $data): Response
    {
        return $this->response->addData(
            VeracoreIntegrationInstanceData::from($this->manager->createIntegrationInstance($data))
        );
    }

    /**
     * @param  IntegrationInstance  $integrationInstance
     * @param  UpdateVeracoreIntegrationInstanceData  $data
     * @return Response
     */
    public function update(IntegrationInstance $integrationInstance, UpdateVeracoreIntegrationInstanceData $data): Response
    {
        return $this->response->addData(
            VeracoreIntegrationInstanceData::from(
                $this->manager->updateIntegrationInstance($integrationInstance, $data)
            )
        );
    }

}
