<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Storing the values here instead of reading from SalesOrderFulfillment::TYPES
     * to ensure that future changes to the constant in code doesn't affect this migration.
     *
     * @var array|string[]
     */
    private array $values = ['manual', 'shipstation', 'starshipit', 'fba', 'shipmyorders', 'veracore'];

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $values = "'" . implode("','", $this->values) . "'";
        \Illuminate\Support\Facades\DB::statement(
            "ALTER TABLE `sales_order_fulfillments` CHANGE `fulfillment_type` `fulfillment_type` ENUM(${values})"
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $values = "'" . implode("','", array_diff($this->values, ['veracore'])) . "'";
        \Illuminate\Support\Facades\DB::statement(
            "ALTER TABLE `sales_order_fulfillments` CHANGE `fulfillment_type` `fulfillment_type` ENUM(${values})"
        );
    }
};
