<?php

namespace Modules\Veracore\Data;

use App\Data\ShippingProviderIntegrationSettingsData;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Model;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Optional;

class VeracoreIntegrationSettingsData extends ShippingProviderIntegrationSettingsData
{
    public function __construct(
        public string $connection_name,
        public Warehouse|Model|array|Optional $linked_warehouse,
        public bool $automate_fulfillment = false,
        public bool $is_deliver_by_date_required = false,
        #[Exists('custom_fields', 'id')]
        public int|string|null $gift_card_note_sales_order_custom_field_id = null,
    ) {
        parent::__construct(
            connection_name: $connection_name,
            linked_warehouse: $linked_warehouse,
            automate_fulfillment: $automate_fulfillment,
        );
    }
}