<?php

namespace Modules\Veracore\Data;

use App\Data\ShippingProviderIntegrationInstanceData;
use App\Models\CustomField;
use App\Models\IntegrationInstance;

class VeracoreIntegrationInstanceData extends ShippingProviderIntegrationInstanceData
{
    public static function fromModel(IntegrationInstance $integrationInstance): ShippingProviderIntegrationInstanceData
    {
        $data = parent::fromModel($integrationInstance);
        return new self(
            id: $data->id,
            name: $data->name,
            integration_id: $data->integration_id,
            connection_settings: $data->connection_settings,
            integration_settings: VeracoreIntegrationSettingsData::from(
                array_merge(
                    $data->integration_settings->toArray(),
                    [
                        'is_deliver_by_date_required' => $integrationInstance->integration_settings['is_deliver_by_date_required'] ?? false,
                        'gift_card_note_sales_order_custom_field_id' => $integrationInstance->integration_settings['gift_card_note_sales_order_custom_field_id'] ?? CustomField::FIELD_NONE,
                    ]
                )
            ),
            is_automatic_sync_enabled: $data->is_automatic_sync_enabled,
            created_at: $data->created_at,
            updated_at: $data->updated_at,
        );
    }

}