<?php

namespace Modules\Shopify\Jobs;

use App\Models\IntegrationInstance;
use App\Repositories\Shopify\ShopifyWebhookEventRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ShopifyOrderWebhookEventJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(
        private IntegrationInstance $integrationInstance,
        private string $webhookTopic,
        private array $order
    ) {
        $this->onQueue('shopifyWebhookEvents');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        (new ShopifyWebhookEventRepository())->save($this->integrationInstance, $this->webhookTopic, $this->order);
    }
}
