<?php

namespace Modules\ShipMyOrders\Tests\Feature;

use App\Models\NominalCode;
use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Sanctum\Sanctum;
use Modules\ShipMyOrders\Entities\ShipMyOrdersInvoiceNominalCodeMappingRule;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class ShipMyOrdersInvoiceNominalCodeMappingRuleControllerTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    protected function setUp(): void
    {
        parent::setUp();

        Sanctum::actingAs(User::first());
    }

    public function test_user_can_list_rules(): void
    {
        ShipMyOrdersInvoiceNominalCodeMappingRule::factory()->count(3)->create();

        $response = $this->getJson(route('shipmyorders.mapping-rules.index'))->assertOk();

        $this->assertCount(3, $response->json()['data']);
    }

    public function test_user_can_create_rule(): void
    {
        $data = [
            'rules' => [
                [
                    'nominal_code_id' => NominalCode::factory()->create()->id,
                    'conditions' => [
                        [
                            'column' => 'description',
                            'operator' => 'contains',
                            'value' => 'USPS'
                        ],
                        [
                            'column' => 'quantity',
                            'operator' => '>',
                            'value' => '0'
                        ]
                    ],
                    'sort_order' => 1
                ]
            ]
        ];

        $this->postJson(route('shipmyorders.mapping-rules.store'), $data)->assertOk();

        $this->assertDatabaseCount(ShipMyOrdersInvoiceNominalCodeMappingRule::class, 1);
    }
}
