<CreateOrderRequest>
    <Username>{{ $username }}</Username>
    <Password>{{ $password }}</Password>
    <ClientID>{{ $clientId }}</ClientID>
    <OrderID>{{ $orderId }}</OrderID>
    <OrderDate>{{ $orderDate }}</OrderDate>
    <OrderStatus>NewOrder</OrderStatus>
    <OrderLineItems>
        @foreach ($orderLines as $orderLine)
            <Item>
                <SKU>{{ $orderLine['productSku'] }}</SKU>
                <Name>{{ $orderLine['productName'] }}</Name>
                <Quantity>{{ $orderLine['orderQuantity'] }}</Quantity>
                <DeclaredValue>{{ $orderLine['declaredValue'] }}</DeclaredValue>
            </Item>
        @endforeach
    </OrderLineItems>
    <ShippingAddress>
        <Company>{{ $shipToCompany }}</Company>
        <Name>{{ $shipToFullName }}</Name>
        <Street1>{{ $shipToAddressLine1 }}</Street1>
        <Street2>{{ $shipToAddressLine2 }}</Street2>
        <City>{{ $shipToCity }}</City>
        <State>{{ $shipToState }}</State>
        <Zip>{{ $shipToZip }}</Zip>
        <Country>{{ $shipToCountry }}</Country>
        <Phone>{{ $shipToPhone }}</Phone>
        @if ($shipToEmailAddress)
            <EmailAddress>{{ $shipToEmailAddress }}</EmailAddress>
        @endif
    </ShippingAddress>
    <ShippingMethod>{{ $shippingMethod }}</ShippingMethod>
    <SignatureRequired>{{ $isSignatureRequired }}</SignatureRequired>
    <SaturdayDelivery>{{ $isSaturdayDelivery }}</SaturdayDelivery>
    @if ($isInsured && $orderInsuranceValue > 0)
        <Insurance>{{ $orderInsuranceValue }}</Insurance>
    @endif
    @if ($usingThirdPartyAccount)
        <ThirdPartyAccount>{{ $thirdPartyAccountNumber }}</ThirdPartyAccount>
        <ThirdPartyAccountBillingZip>{{ $thirdPartyBillingZip }}</ThirdPartyAccountBillingZip>
    @endif
    <AttachedDocs>{{ $hasAttachedDocs }}</AttachedDocs>
    <CommentsCustomer></CommentsCustomer>
    <CommentsPackingSlip>{{ $packingSlipMessage }}</CommentsPackingSlip>
    <CommentsWarehouse>{{ $instructionsForWarehouse }}</CommentsWarehouse>
</CreateOrderRequest>
