<?php

declare(strict_types=1);

namespace Modules\ShipMyOrders\Managers;

use App\Models\ShippingMethod;

class ShipMyOrdersShippingMethodMapperManager
{
    protected static array $skuToSmoMappings = [
        'UPS 2nd Day Air' => 'UPS 2nd Day Air',
        'UPS 2nd Day Air AM' => 'UPS 2nd Day Air AM',
        'UPS 2nd Day Air International' => 'UPS Worldwide Express',
        'UPS 3 Day Select' => 'UPS 3 Day Select',
        'UPS Ground' => 'UPS Ground',
        'UPS Ground International' => 'UPS Intl Ground',
        'UPS Next Day Air' => 'UPS Next Day Air',
        'UPS Next Day Air Early AM' => 'UPS Next Day Air Early A.M.',
        'UPS Next Day Air International' => 'UPS Worldwide Express',
        'UPS Next Day Air Saver' => 'UPS Next Day Air Saver',
        'UPS Standard International' => 'UPS Standard',
        'UPS Worldwide Expedited' => 'UPS Worldwide Expedited',
        'UPS Worldwide Express' => 'UPS Worldwide Express',
        'UPS Worldwide Express Plus' => 'UPS Worldwide Express Plus',
        'UPS Worldwide Saver' => 'UPS Worldwide Saver',
        'FedEx 2 Day' => 'FedEx Express 2nd Day',
        'FedEx 2 Day AM' => 'FedEx Express 2nd Day AM',
        'FedEx Express Saver' => 'FedEx Express 3rd Day',
        'FedEx First Overnight' => 'FedEx Express First Overnight',
        'FedEx Ground' => 'FedEx Ground',
        'FedEx Ground International' => 'FedEx Intl Ground',
        'FedEx Home Delivery' => 'FedEx Home Delivery',
        'FedEx International Economy' => 'FedEx Intl Economy',
        'FedEx International Priority' => 'FedEx Intl Priority',
        'FedEx Priority Overnight' => 'FedEx Express Priority Overnight',
        'FedEx Standard Overnight' => 'FedEx Express Standard Overnight',
        'USPS First Class Mail' => 'USPS First Class Package',
        'USPS First Class Mail International' => 'USPS Intl First Class Package',
        'USPS Media Mail' => 'USPS Media Mail',
        'USPS Parcel Select' => 'USPS Parcel Post',
        'USPS Priority Mail' => 'USPS Priority Mail',
        'USPS Priority Mail Express' => 'USPS Express Mail',
        'USPS Priority Mail Express International' => 'USPS Intl Express Mail',
        'USPS Priority Mail International' => 'USPS Intl Priority Mail',
    ];

    protected static array $smoToSkuMappings = [
        'UPS 2nd Day Air' => 'UPS 2nd Day Air',
        'UPS 2nd Day Air AM' => 'UPS 2nd Day Air AM',
        'UPS 3 Day Select' => 'UPS 3 Day Select',
        'UPS Ground' => 'UPS Ground',
        'UPS Intl Ground' => 'UPS Ground International',
        'UPS Next Day Air' => 'UPS Next Day Air',
        'UPS Next Day Air Early A.M.' => 'UPS Next Day Air Early AM',
        'UPS Next Day Air Saver' => 'UPS Next Day Air Saver',
        'UPS Standard' => 'UPS Standard International',
        'UPS Worldwide Expedited' => 'UPS Worldwide Expedited',
        'UPS Worldwide Express' => 'UPS Worldwide Express',
        'UPS Worldwide Express Plus' => 'UPS Worldwide Express Plus',
        'UPS Worldwide Saver' => 'UPS Worldwide Saver',
        'FedEx Express 2nd Day' => 'FedEx 2 Day',
        'FedEx Express 2nd Day AM' => 'FedEx 2 Day AM',
        'FedEx Express 3rd Day' => 'FedEx Express Saver',
        'FedEx Express First Overnight' => 'FedEx First Overnight',
        'FedEx Ground' => 'FedEx Ground',
        'FedEx Intl Ground' => 'FedEx Ground International',
        'FedEx Home Delivery' => 'FedEx Home Delivery',
        'FedEx Intl Economy' => 'FedEx International Economy',
        'FedEx Intl Priority' => 'FedEx International Priority',
        'FedEx Express Priority Overnight' => 'FedEx Priority Overnight',
        'FedEx Express Standard Overnight' => 'FedEx Standard Overnight',
        'USPS First Class Package' => 'USPS First Class Mail',
        'USPS Intl First Class Package' => 'USPS First Class Mail International',
        'USPS Media Mail' => 'USPS Media Mail',
        'USPS Parcel Post' => 'USPS Parcel Select',
        'USPS Priority Mail' => 'USPS Priority Mail',
        'USPS Express Mail' => 'USPS Priority Mail Express',
        'USPS Intl Express Mail' => 'USPS Priority Mail Express International',
        'USPS Intl Priority Mail' => 'USPS Priority Mail International',
        'USPS Ground Advantage' => 'USPS Priority Mail',
        'USPS Priority Mail Flat Rate Medium Box' => 'USPS Priority Mail',
        'USPS Priority Mail Flat Rate Large Box' => 'USPS Priority Mail',
    ];

    /**
     * Looks up an internal shipping method and returns the ShipMyOrders shipping method.
     *
     * Note: due to urgency on delivering this project, we are going to lookup the shipping
     * method from the database and then map it to the provider's method.
     *
     * This could be done in a more efficient way by using a database lookup
     * but we will leave that for another time.
     */
    public static function translateToShipMyOrdersShippingMethod(ShippingMethod|string $shippingMethod): string
    {
        $lookup = $shippingMethod instanceof ShippingMethod ? $shippingMethod->name : $shippingMethod;

        return (string) (self::$skuToSmoMappings[$lookup] ?? '');
    }

    /**
     * Reverses the translation from ShipMyOrders to the internal shipping method.
     */
    public static function translateToSkuShippingMethod(string $shippingMethod): string
    {
        return (string) (@self::$smoToSkuMappings[$shippingMethod] ?: $shippingMethod);
    }
}
