<?php

namespace Modules\ShipMyOrders\Managers;

use Modules\ShipMyOrders\Entities\ShipMyOrdersIntegrationInstance;
use Modules\ShipMyOrders\Repositories\ShipMyOrdersInventoryRepository;
use Modules\ShipMyOrders\Services\ShipMyOrdersClient;
use Throwable;

class ShipMyOrdersInventoryManager
{
    private ShipMyOrdersIntegrationInstance $instance;
    private ShipMyOrdersClient $client;
    private ShipMyOrdersInventoryRepository $inventory;

    public function __construct()
    {
        if (ShipMyOrdersIntegrationInstance::active())
        {
            $this->instance = ShipMyOrdersIntegrationInstance::active();
            $this->client = new ShipMyOrdersClient($this->instance);
            $this->inventory = app(ShipMyOrdersInventoryRepository::class);
        }
    }

    /**
     * @throws Throwable
     */
    public function refreshInventory(): void
    {
        $data = $this->client->getInventory();

        $this->inventory->save($data);
    }

    public function inventoryDiscrepancies(): array
    {
        return $this->inventory->inventoryDiscrepancies()->toArray();
    }

    public function withoutSkuProducts(): array
    {
        return $this->inventory->withoutSkuProducts()->toArray();
    }

    public function withoutShipMyOrdersInventory(): array
    {
        return $this->inventory->withoutShipMyOrdersInventory()->toArray();
    }
}