<?php

namespace Modules\ShipMyOrders\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\ShipMyOrders\Managers\ShipMyOrdersInventoryManager;
use Throwable;

class ShipMyOrdersRefreshInventoryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct()
    {
    }

    /**
     * @throws Throwable
     */
    public function handle(): void
    {
        app(ShipMyOrdersInventoryManager::class)->refreshInventory();
    }
}
