<?php

declare(strict_types=1);

namespace Modules\ShipMyOrders\Jobs;

use App\DTO\WarehouseDto;
use App\Models\Warehouse;
use App\Repositories\SettingRepository;
use App\Repositories\WarehouseRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\ShipMyOrders\Entities\ShipMyOrdersIntegrationInstance;

class ShipMyOrdersInitializeWarehouseJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public const SHIPMYORDERS_WAREHOUSE_ADDRESS_ARRAY = [
        'name' => 'ShipMyOrders Warehouse',
        'company' => 'ShipMyOrders',
        'address1' => '4031 Industrial Center Dr.',
        'address2' => 'Ste. #705',
        'city' => 'North Las Vegas',
        'province' => 'NV',
        'province_code' => 'NV',
        'zip' => '89030',
        'country' => 'US',
        'country_code' => 'US',
        'phone' => '702-666-0400',
        'email' => 'support@sku.io',
        'label' => 'Warehouse Address',
    ];

    public function __construct(
        protected ShipMyOrdersIntegrationInstance $integrationInstance
    ) {
    }

    public function handle(
        WarehouseRepository $warehouseRepository,
        SettingRepository $settingRepository
    ) {
        $warehouseDto = WarehouseDto::from([
            'name' => 'ShipMyOrders Warehouse',
            'type' => Warehouse::TYPE_3PL,
            'order_fulfillment' => 'shipmyorders',
            'integration_instance_id' => $this->integrationInstance->id,
        ]);
        $warehouse = $warehouseRepository->createWarehouse($warehouseDto->toArray());
        $warehouse->refresh();

        $address = $warehouse->address;
        $address->update(static::SHIPMYORDERS_WAREHOUSE_ADDRESS_ARRAY);

        $settingRepository->addWarehousePriority($warehouse->id);
    }
}
