<?php

namespace Modules\ShipMyOrders\Http\Resources;

use App\DataTable\NewDataTableResource;
use Modules\ShipMyOrders\Entities\ShipMyOrdersInvoice;
use Modules\ShipMyOrders\Entities\ShipMyOrdersInvoiceLine;

/**
 * @mixin ShipMyOrdersInvoice
 */
class ShipMyOrderInvoiceResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'items' => $this->inclusive('items', $this->whenLoaded('shipMyOrdersInvoiceLines', function () {
                return $this->resource->shipMyOrdersInvoiceLines->map(function (ShipMyOrdersInvoiceLine $line) {
                    $line['ship_my_order_invoice_line_id'] = $line->id;
                    $line['fulfillment']                   = [
                        'id' => $line->salesOrderFulfillment?->id,
                        'sales_order_id' => $line->salesOrderFulfillment?->salesOrder->id,
                        'sales_order_number' => $line->salesOrderFulfillment?->salesOrder->sales_order_number,
                    ];
                    return $line;
                });
            })),
        ];
    }
}
