<?php

namespace Modules\ShipMyOrders\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Modules\ShipMyOrders\Managers\ShipMyOrdersInventoryManager;
use Throwable;

class ShipMyOrdersInventoryController extends Controller
{
    private readonly ShipMyOrdersInventoryManager $inventory;

    public function __construct()
    {
        parent::__construct();
        $this->inventory = app(ShipMyOrdersInventoryManager::class);
    }

    /**
     * @throws Throwable
     */
    public function refreshInventory(): JsonResponse
    {
        $this->inventory->refreshInventory();

        return response()->json(['message' => 'Inventory refreshed']);
    }

    public function inventoryDiscrepancies(): JsonResponse
    {
        $inventoryDiscrepancy = $this->inventory->inventoryDiscrepancies();

        return response()->json($inventoryDiscrepancy);
    }

    public function withoutSkuProducts(): JsonResponse
    {
        $withoutSkuProducts = $this->inventory->withoutSkuProducts();

        return response()->json($withoutSkuProducts);
    }

    public function withoutShipMyOrdersInventory(): JsonResponse
    {
        $withoutShipMyOrdersInventory = $this->inventory->withoutShipMyOrdersInventory();

        return response()->json($withoutShipMyOrdersInventory);
    }
}
