<?php

namespace Modules\ShipMyOrders\Entities;

use App\Data\ShippingProviderTrackingInfoData;
use App\Services\ShippingProvider\ShippingProviderOrder;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\ShipMyOrders\Database\factories\ShipMyOrdersOrderFactory;
use Modules\ShipMyOrders\Managers\ShipMyOrdersShippingMethodMapperManager;

/**
 * @property int $id
 * @property int $sku_fulfillment_id
 * @property string|null $reference_number
 * @property array $json_data
 */
class ShipMyOrdersOrder extends ShippingProviderOrder
{
    use HasFactory;

    /**
     * @var string[]
     */
    protected $fillable = [
        'sku_fulfillment_id',
        'reference_number',
        'json_data'
    ];

    /**
     * @var string[]
     */
    protected $casts = [
        'json_data' => 'array'
    ];

    /**
     * @return string|int
     */
    public function getOrderId(): string|int
    {
        return $this->smo_id;
    }

    /**
     * @return ShippingProviderTrackingInfoData
     */
    public function getTrackingInfo(): ShippingProviderTrackingInfoData
    {
        return new ShippingProviderTrackingInfoData(
            $this->json_data['Shipping']['TrackingNumber'],
            ShipMyOrdersShippingMethodMapperManager::translateToSkuShippingMethod($this->json_data['Shipping']['ShippingMethod']),
            $this->json_data['Shipping']['Cost'] ?? 0,
            Carbon::createFromFormat('m/d/Y', $this->json_data['Shipping']['ShipDate']),
            null
        );
    }

    public static function newFactory(): Factory
    {
        return ShipMyOrdersOrderFactory::new();
    }
}
