<?php

namespace Modules\ShipMyOrders\Entities;

use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property string $SKU
 * @property string $Desc
 * @property bool $Active
 * @property int $Stock
 * @property string $UPC
 * @property int $Stock_NV
 * @property array $json_object
 *
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 * @property-read Product $product
 *
 */
class ShipMyOrdersInventory extends Model
{
    use HasFactory;

    protected $table = 'ship_my_orders_inventory';

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function product(): HasOne
    {
        return $this->hasOne(Product::class, 'sku', 'SKU');
    }
}
