<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('ship_my_orders_invoice_lines', function (Blueprint $table) {
            $table->foreignId('nominal_code_id')
                ->nullable()
                ->after('financial_line_id')
                ->constrained()
                ->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::table('ship_my_orders_invoice_lines', function (Blueprint $table) {
            $table->dropColumn('nominal_code_id');
        });
    }
};
