<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('ship_my_orders_inventory', function (Blueprint $table) {
            $table->id();
            $table->string('SKU')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.SKU'))");
            $table->string('Desc')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Desc'))");
            $table->boolean('Active')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Active'))");
            $table->integer('Stock')->storedAs("
                CASE
                    WHEN JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Stock')) = '[]' THEN 0
                    ELSE JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Stock'))
                END
            ");
            $table->string('UPC')->storedAs("
                CASE
                    WHEN JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.UPC')) = '[]' THEN ''
                    ELSE JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.UPC'))
                END
            ");
            $table->integer('Stock_NV')->storedAs(("
                CASE
                    WHEN JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Stock_NV')) = '[]' THEN 0
                    ELSE JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Stock_NV'))
                END
            "));
            $table->json('json_object');
            $table->timestamps();
            $table->unique('SKU');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ship_my_orders_inventory');
    }
};
