<?php

use App\Models\Integration;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Integration::with([])
            ->firstOrCreate(['name' => Integration::NAME_SHIPMYORDERS],
                [
                    'description' => 'Automate order fulfillment with ShipMyOrders',
                    'integration_settings_template' => [],
                    'image_url' => '/images/shipping_providers/shipmyorders.png',
                    'supports_multiple_instances' => false,
                    'integration_type' => Integration::TYPE_SHIPPING_PROVIDER,
                ]
            );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Integration::query()->where('name', Integration::NAME_SHIPMYORDERS)->delete();
    }
};
