<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public array $values = ['manual', 'shipstation', 'starshipit', 'fba'];

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $this->values[] = 'shipmyorders';
        $enums = "'".implode('\',\'', $this->values)."'";
        DB::statement("ALTER TABLE `sales_order_fulfillments` CHANGE `fulfillment_type` `fulfillment_type` ENUM(${enums})");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $enums = "'".implode('\',\'', $this->values)."'";
        DB::statement("ALTER TABLE `sales_order_fulfillments` CHANGE `fulfillment_type` `fulfillment_type` ENUM(${enums})");
    }
};
