<?php

declare(strict_types=1);

namespace Modules\ShipMyOrders\Console;

use App\Jobs\UpdateSMOTrackingInfo;
use Illuminate\Console\Command;
use Modules\ShipMyOrders\Repositories\ShipMyOrdersOrderRepository;

class ShipMyOrdersRefreshTracking extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'sku:smo:refresh-tracking';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Checks for tracking updates for fulfilled orders.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(
        private readonly ShipMyOrdersOrderRepository $orders
    )
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $needingUpdates = $this->orders->getOrderIdsNeedingTrackingInfo();
        if(empty($needingUpdates)) {
            $this->info('No orders need tracking updates.', 1);
            return static::SUCCESS;
        }

        $this->info('Found ' . count($needingUpdates) . ' orders needing tracking updates.', 1);

        $this->info('Refreshing tracking numbers...', 1);
        dispatch_sync(app(UpdateSMOTrackingInfo::class));

        $this->info('Tracking numbers refreshed.', 1);

        return static::SUCCESS;
    }
}
