<?php

namespace Modules\Qbo\Tests\Feature;

use App\Models\SalesChannel;
use App\Models\Supplier;
use App\Models\User;
use Http;
use Illuminate\Support\Facades\Queue;
use Laravel\Sanctum\Sanctum;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Entities\QboVendor;
use Modules\Qbo\Tests\QboMockRequests;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class QboVendorControllerTest extends TestCase
{
    use FastRefreshDatabase;
    use QboMockRequests;

    private QboIntegrationInstance $qboIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();

        $this->qboIntegrationInstance = QboIntegrationInstance::factory()
            ->has(SalesChannel::factory())
            ->create();

        $this->mockGetAccessToken();

        Queue::fake();
        Sanctum::actingAs(User::first());

        Http::preventStrayRequests();
    }

    public function test_qbo_it_can_sync_vendors()
    {
        /*
        |--------------------------------------------------------------------------
        | Refresh accounts
        |--------------------------------------------------------------------------
        */

        $supplier = Supplier::factory()->create();

        $this->mockCreateVendor($supplier);

        $this->postJson(route('qbo.vendors.sync', $this->qboIntegrationInstance->id))->assertOk();

        $this->assertEquals(1, QboVendor::query()->count());
    }
}
