<?php

namespace Modules\Qbo\Tests\Feature;

use App\Models\SalesChannel;
use App\Models\TaxRate;
use App\Models\User;
use Http;
use Illuminate\Support\Facades\Queue;
use Laravel\Sanctum\Sanctum;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Entities\QboTaxCode;
use Modules\Qbo\Manager\QboManager;
use Modules\Qbo\Tests\QboMockRequests;
use Modules\Qbo\Tests\QboTestingData;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class QboTaxCodeControllerTest extends TestCase
{
    use FastRefreshDatabase;
    use QboMockRequests;

    private QboIntegrationInstance $qboIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();

        $this->qboIntegrationInstance = QboIntegrationInstance::factory()
            ->has(SalesChannel::factory())
            ->create();

        $this->mockGetAccessToken();

        Queue::fake();
        Sanctum::actingAs(User::first());

        Http::preventStrayRequests();
    }

    public function test_qbo_tax_code_controller(): void
    {
        /*
        |--------------------------------------------------------------------------
        | Refresh accounts
        |--------------------------------------------------------------------------
        */

        $this->mockRefreshTaxCodes();

        $this->postJson(route('qbo.tax-rates.refresh', $this->qboIntegrationInstance->id))->assertOk();
        (new QboManager($this->qboIntegrationInstance))->refreshTaxCodes(new QboQueryApo());
        $this->assertEquals(QboTestingData::getTaxCodes()['QueryResponse']['maxResults'], QboTaxCode::query()->count());

        $taxRate = TaxRate::factory()->create();
        $this->postJson(route('tax-rates.accounting-mapping', $this->qboIntegrationInstance->id), [
            'tax_rates' => [
                [
                    'id' => $taxRate->id,
                    'accounting_integration_id' => QboTaxCode::query()->first()->id,
                    'accounting_integration_type' => QboTaxCode::class,
                ],
            ],
        ])->assertOk();
    }
}
