<?php

namespace Modules\Qbo\Tests\Feature;

use App\Models\NominalCode;
use App\Models\SalesChannel;
use App\Models\User;
use Http;
use Illuminate\Support\Facades\Queue;
use Laravel\Sanctum\Sanctum;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\Entities\QboAccount;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;
use Modules\Qbo\Tests\QboMockRequests;
use Modules\Qbo\Tests\QboTestingData;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class QboAccountControllerTest extends TestCase
{
    use FastRefreshDatabase;
    use QboMockRequests;

    private QboIntegrationInstance $qboIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();

        $this->qboIntegrationInstance = QboIntegrationInstance::factory()
            ->has(SalesChannel::factory())
            ->create();

        $this->mockGetAccessToken();

        Queue::fake();
        Sanctum::actingAs(User::first());

        Http::preventStrayRequests();
    }

    public function test_qbo_account_controller(): void
    {
        /*
        |--------------------------------------------------------------------------
        | Refresh accounts
        |--------------------------------------------------------------------------
        */

        $this->mockRefreshAccounts();

        $this->postJson(route('qbo.accounts.refresh', $this->qboIntegrationInstance->id))->assertOk();
        (new QboManager($this->qboIntegrationInstance))->refreshAccounts(new QboQueryApo());
        $this->assertEquals(QboTestingData::getAccounts()['QueryResponse']['maxResults'], QboAccount::query()->count());

        $this->postJson(route('qbo.accounts.create-nominal-codes', $this->qboIntegrationInstance->id), [
            'ids' => QboAccount::all()->pluck('id')->values()->toArray(),
        ])->assertOk();

        QboAccount::all()->each(function (QboAccount $qboAccount) {
            $this->assertDatabaseHas((new NominalCode())->getTable(), [
                'code' => $qboAccount->QboId,
            ]);
        });
    }
}
