<?php

namespace Modules\Qbo\Services;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Enums\HttpMethodEnum;
use Exception;
use Modules\Qbo\ApiParameterObjects\QboCreateVendorApo;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\ApiParameterObjects\QboQueryVendorApo;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Data\QboVendorData;

class QboVendorClient extends QboAuthenticationClient
{
    public function __construct(IntegrationInstanceInterface $integrationInstance)
    {
        parent::__construct($integrationInstance);
    }

    public function getVendors(QboQueryVendorApo|QboQueryApo $parameters): QboResponseData
    {
        return $this->getData('Vendor', QboVendorData::class, $parameters);
    }

    public function createVendor(QboCreateVendorApo $parameters): QboResponseData
    {
        $response = $this->request(
            HttpMethodEnum::POST,
            '/vendor',
            $parameters->transform()
        );

        if ($response->ok()) {
            return QboResponseData::from([
                'collection' => collect([
                    QboVendorData::from(array_merge($response->json()['Vendor'], [
                        'json_object' => $response->json()['Vendor'],
                    ])),
                ]),
            ]);
        } elseif ($response->status() === 400 && @$response->json()['Fault']['Error'][0]['Message'] == 'Duplicate Name Exists Error') {
            return $this->getVendors(new QboQueryVendorApo($parameters->displayName));
        } else {

            throw new Exception('Error while creating the vendor.', 1);
        }
    }
}
