<?php

namespace Modules\Qbo\Services;

use App\Abstractions\Integrations\Accounting\AccountingClientInterface;
use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\ClientResponseDataInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use Exception;
use Modules\Qbo\ApiParameterObjects\QboCreateItemApo;
use Modules\Qbo\ApiParameterObjects\QboCreateVendorApo;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\ApiParameterObjects\QboQueryPaymentApo;
use Modules\Qbo\ApiParameterObjects\QboQueryPurchaseOrderApo;
use Modules\Qbo\ApiParameterObjects\QboQueryVendorApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateInvoicesApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreatePaymentsApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreatePurchaseOrdersApo;
use Modules\Qbo\Data\QboAccountData;
use Modules\Qbo\Data\QboBillData;
use Modules\Qbo\Data\QboCreditMemoData;
use Modules\Qbo\Data\QboInvoiceData;
use Modules\Qbo\Data\QboJournalData;
use Modules\Qbo\Data\QboPaymentData;
use Modules\Qbo\Data\QboPurchaseOrderData;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Data\QboTaxCodeData;
use Modules\Qbo\Data\QboTaxRateData;

class QboClient extends QboAuthenticationClient implements AccountingClientInterface
{
    private QboVendorClient $qboVendorClient;

    private QboCustomerClient $qboCustomerClient;

    private QboItemClient $qboItemClient;

    private QboBatchClient $qboBatchClient;

    public function __construct(IntegrationInstanceInterface $integrationInstance)
    {
        parent::__construct($integrationInstance);

        $this->qboVendorClient = new QboVendorClient($integrationInstance);
        $this->qboItemClient = new QboItemClient($integrationInstance);
        $this->qboCustomerClient = new QboCustomerClient($integrationInstance);
        $this->qboBatchClient = new QboBatchClient($integrationInstance);
    }

    /**
     * @throws Exception
     *                   TODO: getAccounts and getInvoices could be moved to an abstract class and getData could be the integration specific implementation
     */
    public function getAccounts(QboQueryApo|ApiDataTransformerInterface $parameters): QboResponseData
    {
        return $this->getData('Account', QboAccountData::class, $parameters);
    }

    /**
     * @throws Exception
     */
    public function getInvoices(QboQueryApo|ApiDataTransformerInterface $parameters): QboResponseData
    {
        return $this->getData('Invoice', QboInvoiceData::class, $parameters);
    }

    public function getPurchaseOrders(QboQueryPurchaseOrderApo|ApiDataTransformerInterface $parameters): QboResponseData
    {
        return $this->getData('PurchaseOrder', QboPurchaseOrderData::class, $parameters);
    }

    public function getPayments(QboQueryPaymentApo|ApiDataTransformerInterface $parameters): QboResponseData
    {
        return $this->getData('Payment', QboPaymentData::class, $parameters);
    }

    public function getTaxRates(QboQueryApo|ApiDataTransformerInterface $parameters): QboResponseData
    {
        return $this->getData('TaxRate', QboTaxRateData::class, $parameters);
    }

    public function getTaxCodes(QboQueryApo|ApiDataTransformerInterface $parameters): QboResponseData
    {
        return $this->getData('TaxCode', QboTaxCodeData::class, $parameters);
    }

    public function getVendors(QboQueryVendorApo|ApiDataTransformerInterface $parameters): QboResponseData
    {
        return $this->qboVendorClient->getVendors($parameters);
    }

    public function createVendor(QboCreateVendorApo|ApiDataTransformerInterface $parameters): ClientResponseDataInterface
    {
        return $this->qboVendorClient->createVendor($parameters);
    }

    public function createProduct(QboCreateItemApo|ApiDataTransformerInterface $parameters): ClientResponseDataInterface
    {
        return $this->qboItemClient->createItem($parameters);
    }

    public function createCustomer(QboCreateVendorApo|ApiDataTransformerInterface $parameters): ClientResponseDataInterface
    {
        return $this->qboCustomerClient->createCustomer($parameters);
    }

    /**
     * @throws Exception
     */
    public function updateOrCreateBills(QboUpdateOrCreatePurchaseOrdersApo|ApiDataTransformerInterface $parameters)
    {
        return $this->qboBatchClient->updateOrCreateBatchRecords($parameters, QboBillData::class);
    }

    /**
     * @throws Exception
     */
    public function updateOrCreatePurchaseOrders(QboUpdateOrCreatePurchaseOrdersApo|ApiDataTransformerInterface $parameters)
    {
        return $this->qboBatchClient->updateOrCreateBatchRecords($parameters, QboPurchaseOrderData::class);
    }

    /**
     * @throws Exception
     */
    public function updateOrCreateInvoices(QboUpdateOrCreateInvoicesApo|ApiDataTransformerInterface $parameters)
    {
        return $this->qboBatchClient->updateOrCreateBatchRecords($parameters, QboInvoiceData::class);
    }

    /**
     * @throws Exception
     */
    public function updateOrCreatePayments(QboUpdateOrCreatePaymentsApo|ApiDataTransformerInterface $parameters)
    {
        return $this->qboBatchClient->updateOrCreateBatchRecords($parameters, QboPaymentData::class);
    }

    /**
     * @throws Exception
     */
    public function updateOrCreateSalesCredits(QboUpdateOrCreateInvoicesApo|ApiDataTransformerInterface $parameters)
    {
        return $this->qboBatchClient->updateOrCreateBatchRecords($parameters, QboCreditMemoData::class);
    }

    /**
     * @throws Exception
     */
    public function updateOrCreateJournals(QboUpdateOrCreateInvoicesApo|ApiDataTransformerInterface $parameters)
    {
        return $this->qboBatchClient->updateOrCreateBatchRecords($parameters, QboJournalData::class);
    }

    /**
     * @throws Exception
     */
    public function deletePayments(ApiDataTransformerInterface $parameters): ClientResponseDataInterface
    {
        return $this->qboBatchClient->deleteBatchRecords($parameters);
    }
}
