<?php

use Illuminate\Support\Facades\Route;
use Modules\Qbo\Http\Controllers\QboAccountController;
use Modules\Qbo\Http\Controllers\QboAuthenticationController;
use Modules\Qbo\Http\Controllers\QboTaxCodeController;
use Modules\Qbo\Http\Controllers\QboTransactionController;
use Modules\Qbo\Http\Controllers\QboVendorController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->group(function () {
    Route::accounting(
        'qbo',
        QboAuthenticationController::class,
        QboAccountController::class,
        QboTaxCodeController::class,
        QboVendorController::class,
        QboTransactionController::class,
    );

    Route::prefix('/qbo/{integrationInstance}')->name('qbo.')->group(function () {
    });
});
